<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class OSF_Custom_Post_Type_Footer
 */
class OSF_Custom_Post_Type_Footer extends OSF_Custom_Post_Type_Abstract {

	/**
	 * @return void
	 */
	public function create_post_type() {

		$labels = array(
			'name'               => __( 'Footer', "huntor-core" ),
			'singular_name'      => __( 'Footer', "huntor-core" ),
			'add_new'            => __( 'Add New Footer', "huntor-core" ),
			'add_new_item'       => __( 'Add New Footer', "huntor-core" ),
			'edit_item'          => __( 'Edit Footer', "huntor-core" ),
			'new_item'           => __( 'New Footer', "huntor-core" ),
			'view_item'          => __( 'View Footer', "huntor-core" ),
			'search_items'       => __( 'Search Footers', "huntor-core" ),
			'not_found'          => __( 'No Footers found', "huntor-core" ),
			'not_found_in_trash' => __( 'No Footers found in Trash', "huntor-core" ),
			'parent_item_colon'  => __( 'Parent Footer:', "huntor-core" ),
			'menu_name'          => __( 'Footer Builder', "huntor-core" ),
		);

		$args = array(
			'labels'              => $labels,
			'hierarchical'        => true,
			'description'         => __( 'List Footer', "huntor-core" ),
			'supports'            => array( 'title', 'editor', 'thumbnail' ), //page-attributes, post-formats
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'menu_position'       => 5,
			'menu_icon'           => $this->get_icon( __FILE__ ),
			'show_in_nav_menus'   => false,
			'publicly_queryable'  => true,
			'exclude_from_search' => true,
			'has_archive'         => true,
			'query_var'           => true,
			'can_export'          => true,
			'rewrite'             => true,
			'capability_type'     => 'post'
		);
		register_post_type( 'footer', $args );
	}


}

new OSF_Custom_Post_Type_Footer;